<?php

namespace UtillzCore\Inc\Src;

use \UtillzCore\Inc\Src;

class Assets {

    use Src\Traits\Singleton;

    function __construct() {

        // scripts
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );

        // thumbnails
        add_action( 'after_setup_theme', [ $this, 'add_image_sizes' ] );

        // listing views
        add_action( 'wp_head', [ $this, 'views' ] );

        // admin menu bar
        add_action( 'admin_bar_menu', [ $this, 'toolbar_add_listing_type_to_listing' ], 80 );
        add_action( 'admin_bar_menu', [ $this, 'toolbar_add_listing_type_to_submission' ], 80 );
        // add_action( 'admin_bar_menu', [ $this, 'toolbar_add_listing_type_to_explore' ], 80 );
        add_action( 'admin_bar_menu', [ $this, 'toolbar_admin_bar' ], 80 );

        // add master class to body
        add_filter( 'body_class', function( $classes ) {
            return array_merge( $classes, $this->body_class(), [ 'utillz' ] );
        });

        add_filter( 'script_loader_tag', [ $this, 'script_loader_tag' ], 10, 2 );

    }

    protected function body_class() {

        global $ulz_explore;

        $classes = [];

        if( Ucore()->is_explore() ) {

            $classes[] = 'ulz-is-explore';
            // $classes[] = sprintf( 'ulz-explore-style--%s', $ulz_explore->get_listing_cover_style() );
            $classes[] = sprintf( 'ulz-explore-type--%s', $ulz_explore->get_explore_type() );
            $classes[] = sprintf( 'ulz-explore-columns--%s', $ulz_explore->get_explore_columns() );

            // geolocation
            if( ! $ulz_explore->request->is_empty('geo') ) {
                $classes[] = 'ulz--explore-geo';
            }

        }

        if( Ucore()->is_submission() ) {
            $classes[] = 'ulz-is-submission';
        }

        return $classes;

    }

    public function script_loader_tag( $tag, $handle ) {

        if( $handle == 'googleapis-platform' ) {
            if( stripos( $tag, 'async' ) === false ) {
                $tag = str_replace(' src', ' async="async" src', $tag);
            }
            if( stripos( $tag, 'defer' ) === false ) {
                $tag = str_replace('<script ', '<script defer ', $tag);
            }
        }

        return $tag;

    }

    public function toolbar_add_listing_type_to_listing( $admin_bar ) {

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if( ! is_single() || get_post_type() !== 'ulz_listing' ) {
            return;
        }

        $post_obj = get_queried_object();
        $listing = new Src\Listing\Listing( $post_obj->ID );

        if( $listing->type->id ) {
            $admin_bar->add_menu([
                'id' => 'ulz-edit-listing-type',
                'title' => 'Edit Listing Type',
                'href' => get_edit_post_link( $listing->type->id ),
                'meta' => [
                    'class' => 'ulz-admin-bar-edit-listing-type',
                ]
            ]);
        }

    }

    public function toolbar_add_listing_type_to_submission( $admin_bar ) {

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if( get_post_type() !== 'page' ) {
            return;
        }

        if( ! function_exists('Ucore') || ! Ucore()->is_submission() ) {
            return;
        }

        global $ulz_submission;

        if( $ulz_submission->listing_type->id ) {
            $admin_bar->add_menu([
                'id' => 'ulz-edit-listing-type',
                'title' => 'Edit Listing Type',
                'href' => get_edit_post_link( $ulz_submission->listing_type->id ),
                'meta' => [
                    'class' => 'ulz-admin-bar-edit-listing-type',
                ]
            ]);
        }

    }

    public function toolbar_admin_bar( $admin_bar ) {

        global $pagenow;

        if ( ! current_user_can( 'manage_options' ) ) {
            return;
        }

        if( $pagenow !== 'post.php' ) {
            return;
        }

        if( ! $explore_page = Ucore()->get_explore_page_url() ) {
            return;
        }

        $post_type = get_post_type();

        // listing type - to explore page
        if( $post_type == 'ulz_listing_type' ) {

            $admin_bar->add_menu([
                'id' => 'ulz-edit-explore-page',
                'title' => 'Visit Explore Page',
                'href' => add_query_arg( 'type', Ucore()->get( 'ulz_slug', get_the_ID() ), $explore_page ),
                'meta' => [
                    'class' => 'ulz-admin-bar-edit-explore-page',
                ]
            ]);

        }
        // listing - to listing type
        elseif( $post_type == 'ulz_listing' ) {

            if( $post_id = (int) $_GET['post'] ) {
                if( $listing_type_id = Ucore()->get( 'ulz_listing_type', $post_id ) ) {
                    $admin_bar->add_menu([
                        'id' => 'ulz-edit-listing-type-page',
                        'title' => 'Edit Listing Type',
                        'href' => get_edit_post_link( $listing_type_id ),
                        'meta' => [
                            'class' => 'ulz-edit-listing-type-page',
                        ]
                    ]);
                }
            }
        }

    }

    public function add_image_sizes() {

        add_image_size( 'ulz_thumbnail', 200, 9999 );
        add_image_size( 'ulz_listing', 800, 528, true );
        add_image_size( 'ulz_gallery_preview', 800 );
        add_image_size( 'ulz_gallery_large', 1920 );

    }

    public function get_vars() {

        global $ulz_explore;

        $vars = [
            'post_id' => null,
            'version' => UTILLZ_CORE_VERSION,
            'debug' => Ucore()->debug,
            'is_admin' => false,
            'admin_ajax' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('ajax-nonce'),
            'site_url' => site_url('/'),
            'uri' => UTILLZ_CORE_URI,
            'date_format' => get_option('date_format'),
            'sdk' => [
                'facebook' => [
                    'enabled' => get_option('ulz_enable_facebook_auth'),
                    'app_id' => get_option('ulz_facebook_app_id')
                ],
                'google' => [
                    'enabled' => get_option('ulz_enable_google_auth'),
                    'client_id' => get_option('ulz_google_client_id')
                ]
            ],
            'localize' => [
                'select' => esc_html__( 'Select', 'utillz-core' ),
                'select_module' => esc_html__('Please select a module', 'utillz-core'),
                'listing_views' => esc_html__( 'Latest views', 'utillz-core' )
            ],
            'pages' => [
                'explore' => Ucore()->get_explore_page_url(),
                'submission' => Ucore()->get_submission_page_url()
            ],
            'map' => [
                'lat' => get_option('ulz_global_map_lat'),
                'lng' => get_option('ulz_global_map_lng')
            ],
            'explore' => [
                'map' => [
                    'center' => [
                        'lat' => get_option('ulz_global_map_lat'),
                        'lng' => get_option('ulz_global_map_lng')
                    ]
                ],
                'is_explore' => Ucore()->is_explore(),
                'is_type' => $ulz_explore ? boolval( $ulz_explore->type ) : false,
            ],
            'chart' => [
                'colors' => [
                    'main' => apply_filters( 'utillz/chart/colors/main', '#333' )
                ]
            ]
        ];

        if( $mapbox_pk = get_option('ulz_mapbox_access_token') ) {
            $vars['sdk']['mapbox'] = [];
            $vars['sdk']['mapbox']['pk'] = esc_attr( $mapbox_pk );
            $vars['sdk']['mapbox']['style'] = esc_attr( get_option('ulz_mapbox_style_url') );
        }

        $page_object = get_queried_object();
        if( isset( $page_object->ID ) ) {
            $vars['post_id'] = $page_object->ID;
        }

        return $vars;
    }

    public function enqueue_scripts() {

        // icons
        wp_enqueue_style( 'font-awesome', UTILLZ_CORE_URI . 'assets/dist/fonts/font-awesome/css/all.min.css', [], UTILLZ_CORE_VERSION );
        wp_enqueue_style( 'material-icons', UTILLZ_CORE_URI . 'assets/dist/fonts/material-icons/material-icons.css' );

        // enqueue custom icon sets
		foreach( utillz_core()->icon->custom_sets as $set_id => $set ) {
			if( isset( $set['css_url'] ) && $set['css_url'] !== '' ) {
				wp_enqueue_style( 'utillz-custom-icons-' . $set_id, $set['css_url'], [], UTILLZ_CORE_VERSION, 'all' );
			}
		}

        /*
         * main
         *
         */

        // layouts
        wp_register_style( 'utillz-layouts', UTILLZ_CORE_URI . 'assets/dist/css/layouts.css', [], UTILLZ_CORE_VERSION );

        // css
        wp_enqueue_style( 'utillz-core-style', UTILLZ_CORE_URI . 'assets/dist/css/core.css', ['utillz-layouts'], UTILLZ_CORE_VERSION );

        // js
        wp_register_script( 'utillz-core', UTILLZ_CORE_URI . 'assets/dist/js/core.js', ['jquery', 'gsap'], UTILLZ_CORE_VERSION, true );
        wp_localize_script( 'utillz-core', 'utillz_core_vars', $this->get_vars() );
        wp_enqueue_script( 'utillz-core' );

        /*
         * map provider
         *
         */
        if( $mapbox_pk = get_option('ulz_mapbox_access_token') ) {
            wp_register_script( 'mapbox-gl', sprintf( '%s://api.tiles.mapbox.com/mapbox-gl-js/v1.9.0/mapbox-gl.js', 'https' ), [], UTILLZ_CORE_VERSION, true );
            wp_add_inline_script('mapbox-gl', 'window.mapboxgl.accessToken = window.utillz_core_vars.sdk.mapbox.pk');
            wp_enqueue_style( 'map-apis-css', sprintf( '%s://api.tiles.mapbox.com/mapbox-gl-js/v1.9.0/mapbox-gl.css', 'https' ), [], UTILLZ_CORE_VERSION );
        }

        /*
         * form
         *
         */
        $args = ['jquery', 'jquery-ui-sortable'];
        if( $mapbox_pk ) {
            $args[] = 'mapbox-gl';
        }
        wp_register_script( 'utillz-form', UTILLZ_CORE_URI . 'assets/dist/js/form.js', $args, UTILLZ_CORE_VERSION, true );
        wp_register_style( 'utillz-form', UTILLZ_CORE_URI . 'assets/dist/css/form.css', [], UTILLZ_CORE_VERSION );

        /*
         * submission
         *
         */
        wp_register_script( 'utillz-submission', UTILLZ_CORE_URI . 'assets/dist/js/submission.js', ['jquery', 'utillz-form'], UTILLZ_CORE_VERSION, true );
        wp_register_style( 'utillz-submission', UTILLZ_CORE_URI . 'assets/dist/css/submission.css', ['utillz-form'], UTILLZ_CORE_VERSION );

        /*
         * explore
         *
         */
        $args = ['jquery', 'utillz-form', 'flickity'];
        if( $mapbox_pk ) {
            $args[] = 'mapbox-gl';
        }
        // if( Ucore()->is_explore() ) {
            wp_register_script( 'utillz-explore', UTILLZ_CORE_URI . 'assets/dist/js/explore.js', $args, UTILLZ_CORE_VERSION, true );
            wp_register_style( 'utillz-explore', UTILLZ_CORE_URI . 'assets/dist/css/explore.css', ['utillz-form'], UTILLZ_CORE_VERSION );
        // }

        /*
         * listing
         *
         */
        $args = ['jquery', 'utillz-form'];
        if( $mapbox_pk ) {
            $args[] = 'mapbox-gl';
        }
        wp_register_script( 'utillz-listing', UTILLZ_CORE_URI . 'assets/dist/js/listing.js', $args, UTILLZ_CORE_VERSION, true );
        wp_register_style( 'utillz-listing', UTILLZ_CORE_URI . 'assets/dist/css/listing.css', ['utillz-form'], UTILLZ_CORE_VERSION );

        /*
         * gsap
         *
         */
        wp_register_script( 'gsap', UTILLZ_CORE_URI . 'assets/dist/lib/gsap/gsap.min.js', [], UTILLZ_CORE_VERSION, true );

        /*
         * vuejs
         *
         */
        wp_register_script( 'vuejs', UTILLZ_CORE_URI . 'assets/dist/lib/vuejs/vue' . Ucore()->assets_min . '.js', [], UTILLZ_CORE_VERSION, true );

        /*
         * flickity
         *
         */
        wp_register_script( 'flickity', UTILLZ_CORE_URI . 'assets/dist/lib/flickity/flickity.pkgd.min.js', [], UTILLZ_CORE_VERSION, true );

        if( function_exists('is_account_page') && is_account_page() ) {

            /*
             * account
             *
             */
            wp_register_script( 'utillz-account', UTILLZ_CORE_URI . 'assets/dist/js/account.js', ['jquery'], UTILLZ_CORE_VERSION, true );
            wp_register_style( 'utillz-account', UTILLZ_CORE_URI . 'assets/dist/css/account.css', [], UTILLZ_CORE_VERSION );
        }

        if( class_exists( 'WooCommerce' ) ) {
            \UtillzCore\Inc\Src\Woocommerce\Init::enqueue_script();
        }

        if( ! is_user_logged_in() ) {

            // facebook sdk
            $enable_fb_auth = get_option('ulz_enable_facebook_auth');
            $fb_app_id = get_option('ulz_facebook_app_id');
            $fb_app_secret = get_option('ulz_facebook_app_secret');

            if( $enable_fb_auth && ! empty( $fb_app_id ) && ! empty( $fb_app_secret ) ) {
                //wp_enqueue_script( 'facebook-sdk', 'https://connect.facebook.net/en_US/sdk.js', ['utillz-theme-main'], '1.0', true );
                add_action( 'wp_footer', [ $this, 'fb_root' ] );
            }

            // google sdk
            $enable_gg_auth = get_option('ulz_enable_google_auth');
            $gg_client_id = get_option('ulz_google_client_id');
            $gg_client_secret = get_option('ulz_google_client_secret');

            if( ! is_user_logged_in() && $enable_gg_auth && ! empty( $gg_client_id ) && ! empty( $gg_client_secret ) ) {
                add_action( 'wp_head', [ $this, 'gg_meta_api_key' ] );
            }
        }

    }

    public function fb_root() {
        echo '<div id="fb-root"></div>';
    }

    public function gg_meta_api_key() {
        $gg_client_id = get_option('ulz_google_client_id');
        echo sprintf( '<meta name="google-signin-client_id" content="%s">', esc_html( $gg_client_id ) );
    }

    public function views() {

        if ( ! is_single() ) {
            return;
        }

        if ( get_post_type() !== 'ulz_listing' ) {
            return;
        }

        if( ! is_main_query() ) {
            return;
        }

        $views = new Src\Listing\Views( get_the_ID() );
        $views->add();

    }

    static function total_views( $user_id = null ) {

        if( is_null( $user_id ) ) {
            $user_id = get_current_user_id();
        }

    }

}
